
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/bandit.zip" ),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
"backpack_blueprint",
"scroll",
}





local fn = function(inst)

local function sanityfn(inst)
local x,y,z = inst.Transform:GetWorldPosition()
local delta = 0
local max_rad = 10
local ents = TheSim:FindEntities(x,y,z, max_rad, nil, nil, {"loner", "clearsky", "duty", "USS", "freedom"})
    for k,v in pairs(ents) do 
if not (v.components.health and v.components.health:IsDead()) then
local sz = -TUNING.SANITYAURA_MED
local rad = 10
sz = sz * ( math.min(max_rad, rad) / max_rad )
local distsq = inst:GetDistanceSqToInst(v)
delta = delta + sz/math.max(1, distsq)
    end
    end
    
    return delta
end
	
	inst.soundsname = "bandit"
	inst:AddTag("bandit")
	inst:AddTag("stalker")
	inst.MiniMapEntity:SetIcon( "bandit.tex" )

	--inst:AddComponent("petleash")
	--inst.components.petleash:SetMaxPets(4)

	inst.components.sanity.custom_rate_fn = sanityfn

	-- Stats	
	inst.components.health:SetMaxHealth(160)
	inst.components.health:SetAbsorptionAmount(0.25)
	inst.components.hunger:SetMax(160)
	inst.components.sanity:SetMax(200)
	inst.components.temperature.inherentinsulation = 60

end

return MakePlayerCharacter("bandit", prefabs, assets, fn, start_inv)
